<?php 
	include "../../conn.php";
	include "../../functions2.php";
	include "rebate_functions.php";

	header('Content-Type: application/json; charset=utf-8');
	header('Strict-Transport-Security: max-age=31536000');
	header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization');
	header('Access-Control-Allow-Credentials: true');
	$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';
	header('Access-Control-Allow-Origin: ' . $origin);
	header('vary: Origin');
	
	date_default_timezone_set("Asia/Kolkata");
	$shnunc = date("Y-m-d H:i:s");
	$res = [
		'code' => 11,
		'msg' => 'Method not allowed',
		'msgCode' => 12,
		'serviceNowTime' => $shnunc,
	];
	$shonubody = file_get_contents("php://input");
	$shonupost = json_decode($shonubody, true);
	if ($_SERVER['REQUEST_METHOD'] != 'GET') {
		if (isset($shonupost['codeType']) && isset($shonupost['language']) && isset($shonupost['random']) && isset($shonupost['signature']) && isset($shonupost['timestamp'])) {
			$codeType = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['codeType']));
			$language = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['language']));
			$random = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['random']));
			$signature = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['signature']));
			$shonustr = '{"codeType":'.$codeType.',"language":'.$language.',"random":"'.$random.'"}';
			$shonusign = strtoupper(md5($shonustr));
			if($shonusign == $signature){
				$bearer = explode(" ", $_SERVER['HTTP_AUTHORIZATION']);
				$author = $bearer[1];				
				$is_jwt_valid = is_jwt_valid($author);
				$data_auth = json_decode($is_jwt_valid, 1);
				if($data_auth['status'] === 'Success') {
					$sesquery = "SELECT id, akshinak
					  FROM shonu_subjects
					  WHERE akshinak = '$author'";
					$sesresult=$conn->query($sesquery);
					$sesnum = mysqli_num_rows($sesresult);
					if($sesnum == 1){
						$sesrow = mysqli_fetch_array($sesresult);
						$userId = $sesrow['id'];
						
						if($codeType == -1 || $codeType == 3){
							// Create table if it doesn't exist
							createBetRebatesTable($conn);
							
							// Get user's VIP level first
							$vipLevel = getUserVipLevel($conn, $userId);
							
							// Only process rebates if user is VIP level 1 or higher
							if ($vipLevel >= 1) {
								// Process any unprocessed bets (this will handle historical bets)
								$gameTables = [
									// Wingo tables
									'bajikattuttate',
									'bajikattuttate_drei', 
									'bajikattuttate_funf',
									'bajikattuttate_zehn',
									// K3 tables  
									'bajikattuttate_kemuru',
									'bajikattuttate_kemuru_drei',
									'bajikattuttate_kemuru_funf', 
									'bajikattuttate_kemuru_zehn',
									// 5D tables
									'bajikattuttate_aidudi',
									'bajikattuttate_aidudi_drei',
									'bajikattuttate_aidudi_funf',
									'bajikattuttate_aidudi_zehn',
									// TRX tables
									'bajikattuttate_trx',
									'bajikattuttate_trx3',
									'bajikattuttate_trx5', 
									'bajikattuttate_trx10'
								];
								
								// Process unprocessed bets
								foreach ($gameTables as $table) {
									// Check if table exists
									$checkTable = "SHOW TABLES LIKE '$table'";
									$tableExists = $conn->query($checkTable);
									
									if ($tableExists->num_rows > 0) {
										// Get unprocessed bets for this user from this table
										$betQuery = "SELECT b.id, b.ketebida, b.tiarikala 
													FROM $table b 
													LEFT JOIN bet_rebates br ON br.bet_id = b.id AND br.game_table = '$table' AND br.user_id = '$userId'
													WHERE b.byabaharkarta = '$userId' AND br.id IS NULL";
										$betResult = $conn->query($betQuery);
										
										if ($betResult && $betResult->num_rows > 0) {
											while ($bet = $betResult->fetch_assoc()) {
												$betAmount = $bet['ketebida'];
												$betTime = $bet['tiarikala'];
												processBetRebate($conn, $userId, $bet['id'], $table, $betAmount, $betTime);
											}
										}
									}
								}
							}
							
							// Get rebate information using the VIP-based system
							$rebateInfo = getUserRebateInfo($conn, $userId);
							$data = $rebateInfo;
						}
						else{
							$data['codeWashAmount'] = 0;
							$data['dayRebate'] = 0;
							$data['totalRebate'] = 0;
							$data['washRate'] = 0.0005;
							$data['washList'] = [];
						}
						
						$res['data'] = $data;
						$res['code'] = 0;
						$res['msg'] = 'Succeed';
						$res['msgCode'] = 0;
						http_response_code(200);
						echo json_encode($res);			
					}
					else{
						$res['code'] = 4;
						$res['msg'] = 'No operation permission';
						$res['msgCode'] = 2;
						http_response_code(401);
						echo json_encode($res);
					}
				}
				else{
					$res['code'] = 4;
					$res['msg'] = 'No operation permission';
					$res['msgCode'] = 2;
					http_response_code(401);
					echo json_encode($res);
				}
			}
			else{
				$res['code'] = 5;
				$res['msg'] = 'Wrong signature';
				$res['msgCode'] = 3;
				http_response_code(200);
				echo json_encode($res);
			}
		}
		else{
			$res['code'] = 7;
			$res['msg'] = 'Param is Invalid';
			$res['msgCode'] = 6;
			http_response_code(200);
			echo json_encode($res);
		}		
	} else {		
		http_response_code(405);
		echo json_encode($res);
	}	
?>